<?php

namespace Modules\Tax\Business;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	public function type()
	{
		return $this->belongsTo('ItemType', 'type_id', 'id');
	}

	public function files()
	{
		return $this->hasMany('ItemFile');
	}

	public function assortment()
	{
		return $this->belongsTo('Assortment');
	}

	public function brand()
	{
		return $this->belongsTo('Brand');
	}

	public function brand_model()
	{
		return $this->belongsTo('BrandModel');
	}

	public function sale()
	{
		return $this->morphedByMany('ItemSale', 'itemable', 'itemables', 'item_id', 'itemable_id')->withPivot('itemable_type')->wherePivot('itemable_type', ItemSale::class)->first();
	}

	public function inventory()
	{
		return $this->morphedByMany('ItemMaterials', 'itemable', 'itemables', 'item_id', 'itemable_id')->withPivot('itemable_type')->wherePivot('itemable_type', ItemInventory::class)->first();
	}

}