<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('code')->unique();
			$table->string('name');
			$table->integer('account_type_id')->unsigned();
			$table->integer('cost_account_id')->nullable();
			$table->integer('default_item_tax_schema_id')->unsigned()->nullable();
			$table->text('remarks')->nullable();
			$table->smallInteger('locked')->unsigned()->default('0');
			$table->smallInteger('is_sales_profit_account')->unsigned()->default('0');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}