<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->char('code')->unique();
			$table->string('name');
			$table->integer('culture_id')->unsigned();
			$table->smallInteger('calling_code')->nullable();
			$table->string('number_format', 20)->nullable();
			$table->string('date_format', 20)->nullable();
			$table->smallInteger('eu_member')->unsigned()->index()->default('0');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}