<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrenciesTable extends Migration {

	public function up()
	{
		Schema::create('currencies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 3)->unique();
			$table->string('iso_code', 3)->unique();
			$table->string('name');
			$table->string('symbol');
			$table->smallInteger('fraction_digits')->unsigned()->default('2');
			$table->smallInteger('prices_fraction_digits')->unsigned()->default('2');
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('currencies');
	}
}