<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiscalDocumentTypesTable extends Migration {

	public function up()
	{
		Schema::create('fiscal_document_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->unique()->nullable();
			$table->integer('fiscal_use_id')->unsigned();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fiscal_document_types');
	}
}