<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIssuingServicesTable extends Migration {

	public function up()
	{
		Schema::create('issuing_services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 2)->unique();
			$table->string('name');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('issuing_services');
	}
}