<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIssuingStationsTable extends Migration {

	public function up()
	{
		Schema::create('issuing_stations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('issuing_service_id')->unsigned();
			$table->integer('user_id');
			$table->string('code', 2)->unique();
			$table->string('name');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('issuing_stations');
	}
}