<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('type_id')->unsigned();
			$table->integer('base_unit_id')->unsigned();
			$table->string('code', 50)->unique();
			$table->string('name');
			$table->text('description')->nullable();
			$table->string('barcode')->unique()->nullable();
			$table->integer('assortment_id')->unsigned()->nullable();
			$table->integer('brand_id')->unsigned()->nullable();
			$table->integer('brand_model_id')->unsigned()->nullable();
			$table->string('legal_basis')->nullable();
			$table->string('regulation_chapter', 5)->nullable()->index();
			$table->string('regulation_section', 5)->nullable()->index();
			$table->string('regulation_article', 5)->nullable()->index();
			$table->string('regulation_number', 5)->nullable()->index();
			$table->string('regulation_item', 5)->nullable()->index();
			$table->string('image')->nullable();
			$table->text('remarks')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}