<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTypesTable extends Migration {

	public function up()
	{
		Schema::create('order_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->nullable();
			$table->integer('fiscal_document_type_id')->unsigned();
			$table->integer('order_nature_id')->unsigned();
			$table->smallInteger('delivery_on_invoice')->unsigned()->default('0');
			$table->integer('notification_id')->nullable();
			$table->integer('contact_type_id')->unsigned();
			$table->integer('default_delivery_type_id');
			$table->integer('default_invoice_type_id')->unsigned()->nullable();
			$table->integer('default_goods_receipt_note_type_id')->nullable();
			$table->integer('default_memo_type_id')->unsigned()->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_types');
	}
}