<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartyTaxSchemasTable extends Migration {

	public function up()
	{
		Schema::create('party_tax_schemas', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->unique()->nullable();
			$table->integer('allowed_in');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('party_tax_schemas');
	}
}