<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxTypeCodesTable extends Migration {

	public function up()
	{
		Schema::create('tax_type_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->unique()->nullable();
			$table->string('print_code')->nullable();
			$table->integer('base_value_id')->unsigned();
			$table->integer('tax_class_id')->unsigned();
			$table->integer('tax_sub_class_id')->unsigned();
			$table->integer('tax_regional_area_id')->unsigned();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tax_type_codes');
	}
}