<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 5)->unique();
			$table->string('name');
			$table->string('symbol', 3)->unique();
			$table->smallInteger('precision_digits')->unsigned()->default('2');
			$table->string('unecerec20', 5);
			$table->smallInteger('is_dimension_base_unit')->unsigned()->index()->default('0');
			$table->integer('unit_dimension_id')->unsigned();
			$table->decimal('conversion_factor')->default('1.0');
			$table->string('formula')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}