<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithholdingTaxCodesTable extends Migration {

	public function up()
	{
		Schema::create('withholding_tax_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description')->nullable();
			$table->integer('withholding_tax_type_id')->unsigned();
			$table->integer('amount_base_id')->unsigned();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('withholding_tax_codes');
	}
}