<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithholdingTaxRatesTable extends Migration {

	public function up()
	{
		Schema::create('withholding_tax_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('withholding_tax_code_id')->unsigned();
			$table->decimal('value')->default('0.0');
			$table->string('description')->nullable();
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('withholding_tax_rates');
	}
}