<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentTypeSeriesTable extends Migration {

	public function up()
	{
		Schema::create('document_type_series', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('seriable_id');
			$table->string('seriable_type');
			$table->integer('serie_id')->unsigned();
			$table->smallInteger('is_default')->unsigned()->default('0');
			$table->smallInteger('number_copies')->unsigned()->default('1');
			$table->smallInteger('tax_included')->unsigned()->default('0');
			$table->integer('economic_activity_classification_id')->unsigned();
			$table->integer('communication_type_id');
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->smallInteger('is_system')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('document_type_series');
	}
}