<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpecialtiesTable extends Migration {

	public function up()
	{
		Schema::create('specialties', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->string('image', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('display_order', true)->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('specialties');
	}
}