<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageSectionsTable extends Migration {

	public function up()
	{
		Schema::create('page_sections', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 255);
			$table->string('subtitle', 255)->nullable();
			$table->longText('description')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('display_order', true)->unique();
			$table->string('image', 255)->nullable();
			$table->bigInteger('page_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('page_sections');
	}
}