<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('client_name', 255)->nullable();
			$table->string('client_phone', 255)->nullable();
			$table->string('client_email', 255)->nullable();
			$table->string('notes', 255)->nullable();
			$table->string('status', 255);
			$table->bigInteger('doctor_id')->unsigned();
			$table->bigInteger('specialty_id')->unsigned();
			$table->bigInteger('procedure_id')->unsigned();
			$table->timestamps();
			$table->date('preferred_date')->nullable();
			$table->time('preferred_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}