<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceProceduresTable extends Migration {

	public function up()
	{
		Schema::create('service_procedures', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('service_id')->unsigned();
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->decimal('price', 10,2)->default('0.0');
			$table->string('image', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('duration_minutes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_procedures');
	}
}