<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommunitiesTable extends Migration {

	public function up()
	{
		Schema::create('communities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->boolean('is_active')->default(1);
			$table->integer('district_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('communities');
	}
}