<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTutosTable extends Migration {

	public function up()
	{
		Schema::create('tutos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->longText('content');
			$table->string('type');
			$table->string('slug')->unique();
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tutos');
	}
}