<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email_address', 'phone');

    public function roles()
    {
        return $this->hasManyThrough('Roles', 'user_roles');
    }

    public function organisations()
    {
        return $this->hasManyThrough('Organisation', 'user_organisations');
    }

}