<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'amount', 'short_url', 'sent_at', 'stage');

	public function notes()
	{
		return $this->hasMany('Notes');
	}

	public function Owner()
	{
		return $this->hasOne('User');
	}

}