<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationsTable extends Migration {

	public function up()
	{
		Schema::create('donations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('age');
			$table->integer('blood_bags_num');
			$table->string('phone');
			$table->string('notes');
			$table->decimal('hospital_longtitude');
			$table->decimal('hospital_latitude');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('blood_type_id')->unsigned();
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('donations');
	}
}