<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->decimal('price')->default('0');
			$table->integer('user_id')->default('1');
			$table->text('attributes')->nullable()->default('[]');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}