<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('phone', 11)->nullable()->index()->default('0000000000');
			$table->string('password', 255);
			$table->string('email', 255);
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}