<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatusTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('status_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('status_id')->unsigned();
			$table->string('name', 255);
			$table->string('expired_name', 255)->nullable()->default('null');
			$table->char('locale', 2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('status_translations');
	}
}