<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManagersTable extends Migration {

	public function up()
	{
		Schema::create('managers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('country_key');
			$table->string('phone');
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('lat');
			$table->string('lng');
			$table->string('address');
			$table->string('commerical_id');
			$table->string('password');
			$table->enum('type', array(''company'', ''individual''));
			$table->string('avatar', 255)->default('default.png');
			$table->string('rate', 255);
			$table->text('bio');
			$table->double('wallet', 100)->default('0,0');
			$table->boolean('is_subscribe');
		});
	}

	public function down()
	{
		Schema::drop('managers');
	}
}