<?php

namespace App\Models;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;
	protected $fillable = array('title', 'content', 'donation_request_id');

	public function donationRequest()
	{
		return $this->belongsTo('App\Models\DonationRequest');
	}

	public function clients()
	{
		return $this->morphToMany('App\Models\Client', 'clientable')->withPivot('is_read');
	}

}