<?php

namespace FaqTypeTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FaqTypeTranslation extends Model 
{

    protected $table = 'faq_types_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function faqType()
    {
        return $this->belongsTo('FaqType', 'faq_type_id');
    }

}