<?php

namespace HomepageCardTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HomepageCardTranslation extends Model 
{

    protected $table = 'homepage_cards_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function homepageCard()
    {
        return $this->belongsTo('HomepageCard', 'homepage_card_id');
    }

}