<?php

namespace LegalInstructionsTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalInstructionsTranslation extends Model 
{

    protected $table = 'legal_instructions_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function legalInstruction()
    {
        return $this->belongsTo('LegalInstruction', 'legal_instruction_id');
    }

}