<?php

namespace PhysicalEntity;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PhysicalEntity extends Model 
{

    protected $table = 'physical_entities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->morphMany('User', 'userable');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}