<?php

namespace UserVoucher;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserVoucher extends Model 
{

    protected $table = 'user_vouchers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function voucher()
    {
        return $this->belongsTo('Voucher', 'voucher_id');
    }

}