<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Doctor extends Model 
{

    protected $table = 'doctor';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'phone', 'vendor_id', 'service_id', 'classification_id', 'biography', 'experience', 'license', 'home_visit_price', 'hospital_price', 'status');

    public function vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

    public function classification()
    {
        return $this->belongsTo('Classification', 'classification_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

}