<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'vendor_id', 'service_id', 'doctor_id', 'date', 'slot_id', 'address', 'status', 'total', 'quantity', 'price', 'tax', 'payment_method', 'coupon_id', 'discount');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function slot()
    {
        return $this->belongsTo('Slot', 'slot_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctor', 'doctor_id');
    }

    public function patients()
    {
        return $this->belongsToMany('Patient', 'order_patient', 'patient_id', 'order_id');
    }

}