<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Patient extends Model 
{

    protected $table = 'patient';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'nationality_id', 'first_name', 'last_name', 'phone', 'iqama_number', 'relationship_id', 'dob', 'age', 'gender', 'insurance_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function nationality()
    {
        return $this->belongsTo('Country', 'nationality_id');
    }

    public function relationship()
    {
        return $this->belongsTo('Relationship', 'relationship_id');
    }

    public function insurance()
    {
        return $this->belongsTo('Insurance', 'insurance_id');
    }

}