<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Review extends Model 
{

    protected $table = 'review';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'vendor_id', 'user_id', 'rating', 'review_en', 'review_ar');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}