<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceCategory extends Model 
{

    protected $table = 'service_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'service_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}