<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorTable extends Migration {

	public function up()
	{
		Schema::create('vendor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->string('website')->nullable();
			$table->double('longitude')->nullable();
			$table->double('latitude')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->double('commission_rate')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vendor');
	}
}