<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'ticket';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title_en', 'title_ar', 'message_en', 'message_ar', 'status', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}