<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyOrderPositionReferenceTable extends Migration {

	public function up()
	{
		Schema::create('plenty_order_position_reference', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('referenceOrderPosition')->unsigned()->index();
			$table->integer('orderPositionId')->unsigned()->index();
			$table->decimal('referenceQuantity', 8,2);
			$table->tinyInteger('isParent')->unsigned()->index()->default('1');
			$table->timestamps();
			$table->timestamp('createdAt');
		});
	}

	public function down()
	{
		Schema::drop('plenty_order_position_reference');
	}
}