<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyOrderAmountTable extends Migration {

	public function up()
	{
		Schema::create('plenty_order_amount', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('orderId')->unsigned()->index();
			$table->tinyInteger('isSystemCurrency')->unique()->unsigned()->default('1');
			$table->tinyInteger('isNet')->default('0');
			$table->string('currency', 3);
			$table->decimal('exchangeRatio', 12,6);
			$table->decimal('netTotal', 11,2);
			$table->decimal('grossTotal', 11,2);
			$table->decimal('vatTotal', 11,2);
			$table->decimal('invoiceTotal', 11,2);
			$table->decimal('paidAmount', 11,2);
			$table->decimal('prepaidAmount', 11,2);
			$table->timestamps();
			$table->timestamp('createdAt');
		});
	}

	public function down()
	{
		Schema::drop('plenty_order_amount');
	}
}