<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyOrderPositionAmountTable extends Migration {

	public function up()
	{
		Schema::create('plenty_order_position_amount', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('orderPositionId')->unsigned();
			$table->tinyInteger('isSystemCurrency')->unique()->unsigned()->default('1');
			$table->integer('countryVatId')->unsigned()->index();
			$table->integer('vatId');
			$table->string('currency', 3);
			$table->decimal('exchangeRatio', 12,6);
			$table->decimal('vatAmount', 4,2);
			$table->decimal('priceOriginalGross', 13,4);
			$table->decimal('priceGross', 13,4);
			$table->decimal('markup', 11,2);
			$table->decimal('rabate', 11,2);
			$table->tinyInteger('isPercentel')->unsigned();
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plenty_order_position_amount');
	}
}