<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('plenty_order', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order', function(Blueprint $table) {
			$table->foreign('statusId')->references('id')->on('plenty_order_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_position', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_position', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_position_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_position_option', function(Blueprint $table) {
			$table->foreign('orderPositionId')->references('id')->on('plenty_order_position')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_position_option', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_option_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_position_option', function(Blueprint $table) {
			$table->foreign('subTypeId')->references('id')->on('plenty_order_option_sub_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_amount', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_option', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_option', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_option_type')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_option', function(Blueprint $table) {
			$table->foreign('subTypeId')->references('id')->on('plenty_order_option_sub_type')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_option_sub_type_name', function(Blueprint $table) {
			$table->foreign('subTypeId')->references('id')->on('plenty_order_option_sub_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_option_type_name', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_option')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_date_option', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_date_option', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_date_option_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_position_date_option', function(Blueprint $table) {
			$table->foreign('orderPositionId')->references('id')->on('plenty_order_position')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_position_date_option', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_date_option_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_date_option_type_name', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_date_option_type_name')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_reference', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_reference', function(Blueprint $table) {
			$table->foreign('referenceOrder')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_position_reference', function(Blueprint $table) {
			$table->foreign('referenceOrderPosition')->references('id')->on('plenty_order_position')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_position_reference', function(Blueprint $table) {
			$table->foreign('orderPositionId')->references('id')->on('plenty_order_position')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_type_name', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_position_type_name', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_order_position_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_status_name', function(Blueprint $table) {
			$table->foreign('statusId')->references('id')->on('plenty_order_status_name')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_amount_vat', function(Blueprint $table) {
			$table->foreign('orderAmountId')->references('id')->on('plenty_order_amount')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_position_amount', function(Blueprint $table) {
			$table->foreign('orderPositionId')->references('id')->on('plenty_order_position')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_event_type_name', function(Blueprint $table) {
			$table->foreign('typeId')->references('id')->on('plenty_event_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_event_source_name', function(Blueprint $table) {
			$table->foreign('sourceId')->references('id')->on('plenty_event_source')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('plenty_order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->foreign('eventTypeId')->references('id')->on('plenty_event_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->foreign('statusId')->references('id')->on('plenty_order_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->foreign('eventSourceId')->references('id')->on('plenty_event_source')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('plenty_order', function(Blueprint $table) {
			$table->dropForeign('plenty_order_typeId_foreign');
		});
		Schema::table('plenty_order', function(Blueprint $table) {
			$table->dropForeign('plenty_order_statusId_foreign');
		});
		Schema::table('plenty_order_position', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_orderId_foreign');
		});
		Schema::table('plenty_order_position', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_typeId_foreign');
		});
		Schema::table('plenty_order_position_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_option_orderPositionId_foreign');
		});
		Schema::table('plenty_order_position_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_option_typeId_foreign');
		});
		Schema::table('plenty_order_position_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_option_subTypeId_foreign');
		});
		Schema::table('plenty_order_amount', function(Blueprint $table) {
			$table->dropForeign('plenty_order_amount_orderId_foreign');
		});
		Schema::table('plenty_order_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_option_orderId_foreign');
		});
		Schema::table('plenty_order_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_option_typeId_foreign');
		});
		Schema::table('plenty_order_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_option_subTypeId_foreign');
		});
		Schema::table('plenty_order_option_sub_type_name', function(Blueprint $table) {
			$table->dropForeign('plenty_order_option_sub_type_name_subTypeId_foreign');
		});
		Schema::table('plenty_order_option_type_name', function(Blueprint $table) {
			$table->dropForeign('plenty_order_option_type_name_typeId_foreign');
		});
		Schema::table('plenty_order_date_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_date_option_orderId_foreign');
		});
		Schema::table('plenty_order_date_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_date_option_typeId_foreign');
		});
		Schema::table('plenty_order_position_date_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_date_option_orderPositionId_foreign');
		});
		Schema::table('plenty_order_position_date_option', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_date_option_typeId_foreign');
		});
		Schema::table('plenty_order_date_option_type_name', function(Blueprint $table) {
			$table->dropForeign('plenty_order_date_option_type_name_typeId_foreign');
		});
		Schema::table('plenty_order_reference', function(Blueprint $table) {
			$table->dropForeign('plenty_order_reference_orderId_foreign');
		});
		Schema::table('plenty_order_reference', function(Blueprint $table) {
			$table->dropForeign('plenty_order_reference_referenceOrder_foreign');
		});
		Schema::table('plenty_order_position_reference', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_reference_referenceOrderPosition_foreign');
		});
		Schema::table('plenty_order_position_reference', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_reference_orderPositionId_foreign');
		});
		Schema::table('plenty_order_type_name', function(Blueprint $table) {
			$table->dropForeign('plenty_order_type_name_typeId_foreign');
		});
		Schema::table('plenty_order_position_type_name', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_type_name_typeId_foreign');
		});
		Schema::table('plenty_order_status_name', function(Blueprint $table) {
			$table->dropForeign('plenty_order_status_name_statusId_foreign');
		});
		Schema::table('plenty_order_amount_vat', function(Blueprint $table) {
			$table->dropForeign('plenty_order_amount_vat_orderAmountId_foreign');
		});
		Schema::table('plenty_order_position_amount', function(Blueprint $table) {
			$table->dropForeign('plenty_order_position_amount_orderPositionId_foreign');
		});
		Schema::table('plenty_event_type_name', function(Blueprint $table) {
			$table->dropForeign('plenty_event_type_name_typeId_foreign');
		});
		Schema::table('plenty_event_source_name', function(Blueprint $table) {
			$table->dropForeign('plenty_event_source_name_sourceId_foreign');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->dropForeign('plenty_order_event_orderId_foreign');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->dropForeign('plenty_order_event_eventTypeId_foreign');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->dropForeign('plenty_order_event_statusId_foreign');
		});
		Schema::table('plenty_order_event', function(Blueprint $table) {
			$table->dropForeign('plenty_order_event_eventSourceId_foreign');
		});
	}
}