<?php

namespace Plenty\Modules\Order\Models;

class OrderDateOption extends Eloquent {

	protected $table = 'plenty_order_date_option';
	public $timestamps = true;
	protected $guarded = array('id');
	protected $fillable = array('orderId', 'typeId', 'date');
	protected $visible = array('id', 'orderId', 'typeId', 'date', 'createdAt', 'updatedAt');

	public function type()
	{
		return $this->hasOne('OrderDateOptionType', 'id', 'typeId');
	}

	public function orders()
	{
		return $this->belongsTo('Order', 'orderId');
	}

}