<?php

namespace Plenty\Modules\Order\Models;

class OrderOption extends Eloquent {

	protected $table = 'plenty_order_option';
	public $timestamps = false;
	protected $guarded = array('id');
	protected $fillable = array('orderId', 'typeId', 'subTypeId', 'value');
	protected $visible = array('id', 'orderId', 'typeId', 'subTypeId', 'value', 'updatedAt', 'createdAt');

	public function type()
	{
		return $this->hasOne('OrderOptionType', 'id', 'typeId');
	}

	public function subType()
	{
		return $this->hasOne('OrderOptionSubType', 'id', 'subTypeId');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'orderId');
	}

}