<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->string('card_code', 20)->unique();
			$table->string('card_name', 255);
			$table->string('email', 100);
			$table->integer('price_list_id');
			$table->integer('group_id');
			$table->boolean('active');
			$table->datetime('logged_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}