<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderLineTable extends Migration {

	public function up()
	{
		Schema::create('order_line', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id');
			$table->string('sku');
			$table->string('name');
			$table->integer('quantity');
			$table->float('amount');
			$table->decimal('discount');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_line');
	}
}