<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('label', 255)->nullable()->index()->default('NULL');
			$table->enum('domain', array('DIRECTIONGENERALE', 'AFFAIRESGENERALES', 'AFFAIRESJURIDIQUES', 'FINANCES', 'RESSOURCESHUMAINES', 'SYSTEMESD'INFORMATIONETTIC', 'COMMUNICATION', 'DEVELOPPEMENTTERRITORIAL', 'ENVIRONNEMENT', 'URBANISMEETAMENAGEMENT', 'TRANSPORTSETDEPLACEMENTS', 'FORMATIONPROFESSIONN'))->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}